---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-Job Detail（ジョブ詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **StageTableBaseのカラム定義詳細**：StageTableBase.scalaの直接確認が不完全

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` （JobPageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/JobsTab.scala` （JobsTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.2の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.2の関連機能）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` （JobsTab内の遷移関係）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /jobs/job/?id={jobId} | E-01 (36行目: WebUIPage("job")) | ○ |
| C-02 | idパラメータが必須 | E-01 (225-226行目: require(parameterId != null && parameterId.nonEmpty)) | ○ |
| C-03 | ジョブデータはjobWithAssociatedSqlで取得される | E-01 (229行目: store.jobWithAssociatedSql(jobId)) | ○ |
| C-04 | ジョブが存在しない場合はエラーメッセージを表示 | E-01 (230-236行目: "No information to display") | ○ |
| C-05 | ステージはActive/Completed/PendingOrSkipped/Failedに分類 | E-01 (315-332行目: 4つのBuffer) | ○ |
| C-06 | ジョブ完了時はPendingステージがSkippedとして表示 | E-01 (336-341行目: isComplete判定でtableId変更) | ○ |
| C-07 | 未到着ステージにダミーStageDataが生成される | E-01 (242-312行目: new v1.StageData with PENDINGステータス) | ○ |
| C-08 | DAG可視化はoperationGraphForJobで取得 | E-01 (450行目: store.operationGraphForJob(jobId)) | ○ |
| C-09 | DAG情報が無い場合はメッセージを表示 | E-01 (453-455行目: "No DAG visualization information") | ○ |
| C-10 | showVisualization=trueでページが表示される | E-01 (528行目: showVisualization = true) | ○ |
| C-11 | 関連SQLクエリIDがある場合リンクが表示される | E-01 (382-390行目: sqlExecutionId.isDefined) | ○ |
| C-12 | SQL実行詳細へのリンクURL形式 | E-01 (385-387行目: basePath/SQL/execution/?id=) | ○ |
| C-13 | ジョブグループがある場合に表示される | E-01 (393-399行目: jobData.jobGroup.isDefined) | ○ |
| C-14 | タイムラインはUI_TIMELINE_ENABLEDで制御 | E-01 (38行目: TIMELINE_ENABLED, 158行目: if (!TIMELINE_ENABLED)) | ○ |
| C-15 | タイムラインステージ最大数はUI_TIMELINE_STAGES_MAXIMUM | E-01 (39行目: MAX_TIMELINE_STAGES) | ○ |
| C-16 | ステージ凡例: Completed/Failed/Active | E-01 (42-53行目: STAGES_LEGEND) | ○ |
| C-17 | サマリーにStatus, Submitted, Durationを表示 | E-01 (367-380行目: summary内のli) | ○ |
| C-18 | Active Stageに対してKillが可能 | E-01 (344-346行目: killEnabled = parent.killEnabled) | ○ |
| C-19 | Completed/Failed/SkippedステージテーブルはKill無効 | E-01 (348-358行目: killEnabled = false) | ○ |
| C-20 | makeStageEventでステージをJSONに変換 | E-01 (65-105行目) | ○ |
| C-21 | makeExecutorEventでExecutorイベントをJSONに変換 | E-01 (107-151行目) | ○ |
| C-22 | drawJobTimeline関数を呼び出す | E-01 (219行目: drawJobTimeline) | ○ |
| C-23 | FAIRスケジューラ使用時はプール情報が表示される | E-01 (344行目: parent.isFairScheduler) | ○ |
| C-24 | ステージ分類ロジック: submissionTime無=Pending, completionTime有+FAILED=Failed, completionTime有+他=Completed, else=Active | E-01 (320-332行目) | ○ |
| C-25 | StageTableBaseのカラム定義がFAIR時に変わる | **根拠不足**（StageTableBase.scalaの直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- StageTableBase.scalaの詳細なカラム定義
  - 候補：`core/src/main/scala/org/apache/spark/ui/jobs/StageTableBase.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メイン処理フローはJobPage.scalaで完全に確認済み
- 0: 低リスク - データ取得APIはソースコードで確認済み
- 1: 中リスク - StageTableBaseの詳細カラム定義は間接的な推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] ダミーStageData生成のフィールド値が適切か確認
- [ ] SQL実行詳細へのリンクURLが正しいか確認
- [ ] FAIRスケジューラ時のテーブル表示差異が正確か確認
- [ ] タイムラインの設定パラメータ名とデフォルト値を確認
